/*
 * Decompiled with CFR 0.152.
 */
package ru.xe.kon.core;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import ru.xe.common.lang.Util;
import ru.xe.kon.core.KonHttpFacade;
import ru.xe.kon.core.model.ConnectionResult;
import ru.xe.kon.core.model.DayInfo;

public class KonHttpFacadeImpl
implements KonHttpFacade {
    private static final String SERVER_URL = "http://www.konserver.ru/";
    private static final String MONTH_BEGIN = "MONTH_BEGIN";
    private static final String CITY = "CITY";
    private static final String APPLICATION_ID = "APPLICATION_ID";

    public ConnectionResult getData(String[] sysData, boolean monthBegin) {
        ConnectionResult result = new ConnectionResult();
        String[] requestProperties = this.getRequestProperties(sysData, monthBegin);
        try {
            StreamConnection connection = null;
            connection = (StreamConnection)Connector.open((String)"http://www.konserver.ru/waqitcibaru.php");
            StringBuffer data = new StringBuffer();
            boolean first = true;
            for (int i = 0; i < requestProperties.length / 2; ++i) {
                if (first) {
                    first = !first;
                } else {
                    data.append("&");
                }
                data.append(requestProperties[2 * i]);
                data.append("=");
                data.append(requestProperties[2 * i + 1]);
            }
            OutputStreamWriter out = new OutputStreamWriter(connection.openOutputStream());
            out.write(data.toString());
            out.flush();
            out.close();
            DataInputStream response = connection.openDataInputStream();
            String line = response.readUTF();
            int n = 0;
            if (line != null) {
                try {
                    n = Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("line1 = " + line);
                }
            }
            String[] advertisings = new String[n];
            for (int i = 0; i < n && (line = response.readUTF()) != null; ++i) {
                advertisings[i] = line;
            }
            result.setAdvertisings(advertisings);
            line = response.readUTF();
            n = 0;
            if (line != null) {
                try {
                    n = Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("line2 = " + line);
                }
            }
            DayInfo[] dayInfos = new DayInfo[n];
            for (int i = 0; i < n && (line = response.readUTF()) != null; ++i) {
                DayInfo dayInfo = new DayInfo();
                dayInfo.setHours(this.getListFromString(line));
                line = response.readUTF();
                if (line != null) {
                    dayInfo.setMinutes(this.getListFromString(line));
                }
                dayInfos[i] = dayInfo;
            }
            result.setDayInfos(dayInfos);
            line = response.readUTF();
            n = 0;
            if (line != null) {
                try {
                    n = Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("line3 = " + line);
                }
            }
            DayInfo[] dayInfos2 = new DayInfo[n];
            for (int i = 0; i < n && (line = response.readUTF()) != null; ++i) {
                if (i < dayInfos.length) {
                    dayInfos2[i] = dayInfos[i];
                    dayInfos2[i].setInfo(line);
                    continue;
                }
                DayInfo dayInfo = new DayInfo();
                dayInfo.setInfo(line);
                dayInfos2[i] = dayInfo;
            }
            result.setDayInfos(dayInfos2);
            this.normilizeDayInfos(result.getDayInfos());
            line = response.readUTF();
            n = 0;
            if (line != null) {
                try {
                    n = Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("line4 = " + line);
                }
            }
            if (n > 0) {
                line = response.readUTF();
                result.setEmagencyInfo(line);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("IO Ex");
        }
        return result;
    }

    public String[] registration(String[] sysData) {
        String[] result = sysData;
        try {
            StreamConnection connection = null;
            connection = (StreamConnection)Connector.open((String)"http://www.konserver.ru/yananiqabulitu.php");
            String data = "YANGA_QULLANICI=BISMILLAAHIRRAXMAANIRRAXIIM";
            OutputStreamWriter out = new OutputStreamWriter(connection.openOutputStream());
            out.write(data.toString());
            out.flush();
            DataInputStream response = connection.openDataInputStream();
            String line = response.readUTF();
            int n = 0;
            if (line != null) {
                try {
                    n = Integer.parseInt(line);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("line5 = " + line);
                }
            }
            if (n > 0 && (line = response.readUTF()) != null) {
                result[2] = line.trim();
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("IO ex");
        }
        return result;
    }

    private String[] getRequestProperties(String[] sysData, boolean monthBegin) {
        String[] result = new String[2 * (monthBegin ? 3 : 2)];
        result[0] = APPLICATION_ID;
        result[1] = sysData[2];
        String city = sysData[2];
        if (Util.isEmpty(city)) {
            city = "-1";
        }
        result[2] = CITY;
        result[3] = city;
        if (monthBegin) {
            result[4] = MONTH_BEGIN;
            result[5] = String.valueOf(monthBegin);
        }
        return result;
    }

    private Integer[] getListFromString(String line) {
        Integer[] result = new Integer[7];
        line = line.trim();
        int r = 0;
        int l = -1;
        r = line.indexOf(" ", l);
        int i = 0;
        while (r >= 0) {
            r = line.indexOf(" ", l + 1);
            String s = r < 0 ? line.substring(l + 1).trim() : line.substring(l + 1, r).trim();
            int n = 0;
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("line = " + line + "; s = " + s + "; i = " + String.valueOf(i));
            }
            result[i] = new Integer(n);
            ++i;
            l = r;
        }
        return result;
    }

    private void normilizeDayInfos(DayInfo[] dayInfos) {
        for (int j = 0; j < dayInfos.length; ++j) {
            int i;
            Integer[] time = dayInfos[j].getHours();
            for (i = time.length - 1; i < 6; ++i) {
                time[i] = new Integer(-1);
            }
            dayInfos[j].setHours(time);
            time = dayInfos[j].getMinutes();
            for (i = time.length - 1; i < 6; ++i) {
                time[i] = new Integer(-1);
            }
            dayInfos[j].setMinutes(time);
        }
    }

    public void getDataAndSave(String[] sysData, boolean monthBegin) {
    }
}

