/*
 * Decompiled with CFR 0.152.
 */
package ru.xe.kon.core;

import java.util.Calendar;
import java.util.Date;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotOpenException;
import ru.xe.common.lang.Util;
import ru.xe.kon.core.ConvertUtils;
import ru.xe.kon.core.FileFactory;
import ru.xe.kon.core.KonFacade;
import ru.xe.kon.core.KonFacadeImplFile;
import ru.xe.kon.core.KonHttpFacadeImplModMono;
import ru.xe.kon.core.model.City;
import ru.xe.kon.core.model.DayInfo;

public class KonFacadeImplFileMono
extends KonFacadeImplFile
implements KonFacade {
    public KonFacadeImplFileMono(FileFactory activity) {
        super(activity, true);
        this.konHttpFacade = new KonHttpFacadeImplModMono();
    }

    public void saveData(String[] advertisings, DayInfo[] dayInfos, String emagencyInfo) {
        try {
            byte[] writeData;
            int i;
            int[] sizes;
            RecordStore store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            int numRecords = store.getNumRecords();
            this.curPos = 0;
            if (numRecords > 0) {
                sizes = ConvertUtils.getSizes(store.getRecord(1));
            } else {
                sizes = new int[4];
                for (i = 0; i < 4; ++i) {
                    sizes[i] = 0;
                }
                sizes[0] = 11;
                this.addRec(store, numRecords, ConvertUtils.convertSizesToByte(sizes));
                for (i = 0; i < sizes[0]; ++i) {
                    this.addRec(store, numRecords, KonFacadeImplFileMono.convertStringToByte(" "));
                }
            }
            this.curPos = sizes[0];
            sizes[1] = sizes[0] + advertisings.length;
            for (i = 0; i < advertisings.length; ++i) {
                writeData = KonFacadeImplFileMono.convertStringToByte(advertisings[i]);
                this.addRec(store, numRecords, writeData);
            }
            sizes[2] = sizes[1] + dayInfos.length;
            for (i = 0; i < dayInfos.length; ++i) {
                writeData = this.convertTimeToByte(dayInfos[i]);
                this.addRec(store, numRecords, writeData);
            }
            sizes[3] = sizes[2] + dayInfos.length;
            for (i = 0; i < dayInfos.length; ++i) {
                writeData = KonFacadeImplFileMono.convertStringToByte(dayInfos[i].getInfo());
                this.addRec(store, numRecords, writeData);
            }
            this.curPos = 0;
            this.addRec(store, numRecords, ConvertUtils.convertSizesToByte(sizes));
            this.sysData = null;
            String[] systemData = this.getSysData(store, true);
            if (systemData == null || systemData.length == 0) {
                systemData = new String[10];
            }
            systemData[0] = emagencyInfo;
            this.saveSysData(systemData, null, store, true);
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
    }

    public String[] getSysData() {
        return this.getSysData(null, false);
    }

    public String[] getSysData(RecordStore store, boolean withoutClose) {
        if (this.sysData == null) {
            try {
                if (store == null) {
                    store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
                }
            }
            catch (RecordStoreException ex) {
                return new String[10];
            }
            try {
                int length = 10;
                this.sysData = new String[length];
                if (store.getNumRecords() < length + 1) {
                    String[] stringArray = this.sysData;
                    return stringArray;
                }
                for (int i = 0; i < length - 1; ++i) {
                    this.sysData[i] = this.convertByteToString(store.getRecord(i + 2));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Exception");
            }
            finally {
                try {
                    if (store != null && !withoutClose) {
                        store.closeRecordStore();
                    }
                }
                catch (RecordStoreNotOpenException e) {
                }
                catch (RecordStoreException ex) {
                    return new String[10];
                }
            }
        }
        return this.sysData;
    }

    protected void saveSysData() {
        this.saveSysData(null, false);
    }

    protected void saveSysData(RecordStore store, boolean withoutClose) {
        this.saveSysData(this.sysData, null, store, withoutClose);
    }

    public void saveSysData(String[] data) {
        this.saveSysData(data, null);
    }

    public void saveSysData(String[] data, byte[] cityData) {
        this.saveSysData(data, cityData, null, false);
    }

    public void saveSysData(String[] data, byte[] cityData, RecordStore store, boolean withoutClose) {
        this.sysData = data;
        try {
            if (store == null) {
                store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            }
            if (this.sysData != null) {
                int i;
                int[] sizes;
                int n = 10;
                int numRecords = store.getNumRecords();
                this.curPos = 0;
                if (numRecords > 0) {
                    sizes = ConvertUtils.getSizes(store.getRecord(1));
                    this.curPos = 1;
                } else {
                    sizes = new int[4];
                    for (i = 0; i < 4; ++i) {
                        sizes[i] = 0;
                    }
                    sizes[0] = 12;
                    this.addRec(store, numRecords, ConvertUtils.convertSizesToByte(sizes));
                }
                for (i = 0; i < n; ++i) {
                    byte[] writeData = KonFacadeImplFileMono.convertStringToByte(this.sysData[i]);
                    this.addRec(store, numRecords, writeData);
                }
                if (cityData != null) {
                    this.addRec(store, numRecords, cityData);
                }
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception");
        }
        finally {
            try {
                if (store != null && !withoutClose) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getAdvertisings() {
        String[] result = new String[]{};
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            int count = store.getNumRecords();
            if (count == 0) {
                String[] stringArray = result;
                return stringArray;
            }
            int[] sizes = ConvertUtils.getSizes(store.getRecord(1));
            if (sizes == null || sizes.length < 4) {
                String[] ex = result;
                return ex;
            }
            count = sizes[1];
            if (count - sizes[0] < 0) {
                String[] ex = result;
                return ex;
            }
            result = new String[count - sizes[0]];
            int i = sizes[0] - 1;
            int j = 0;
            while (i + 1 < count) {
                String line;
                result[j] = line = this.convertByteToString(store.getRecord(++i + 1));
                ++j;
            }
            return result;
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DayInfo[] getDayInfos() {
        DayInfo[] result = new DayInfo[]{};
        DayInfo dayInfo = null;
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            int count = store.getNumRecords();
            if (count == 0) {
                DayInfo[] dayInfoArray = result;
                return dayInfoArray;
            }
            int[] sizes = ConvertUtils.getSizes(store.getRecord(1));
            if (sizes == null || sizes.length < 4) {
                DayInfo[] ex = result;
                return ex;
            }
            count = sizes[2];
            int count1 = sizes[1];
            int n1 = sizes[2];
            result = new DayInfo[count - sizes[1]];
            int n = sizes[1] + 1;
            while (n <= count) {
                dayInfo = new DayInfo();
                byte[] readedData = null;
                readedData = store.getRecord(n);
                this.convertByteToTime(readedData, dayInfo);
                readedData = null;
                if (++n1 <= store.getNumRecords()) {
                    readedData = store.getRecord(n1);
                }
                dayInfo.setInfo(this.convertByteToString(readedData));
                result[n - count1 - 1] = dayInfo;
                ++n;
            }
            return result;
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DayInfo getDayInfo(Integer day) {
        DayInfo result = null;
        RecordStore store = null;
        Object store1 = null;
        try {
            int n = day != null ? day : 1;
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
            int count = store.getNumRecords();
            if (count == 0) {
                DayInfo dayInfo = new DayInfo();
                return dayInfo;
            }
            int[] sizes = ConvertUtils.getSizes(store.getRecord(1));
            if (sizes == null || sizes.length < 4) {
                DayInfo ex = new DayInfo();
                return ex;
            }
            int n1 = sizes[2] + n;
            if ((n += sizes[1]) > store.getNumRecords() || n1 > store.getNumRecords()) {
                DayInfo ex = new DayInfo();
                return ex;
            }
            result = new DayInfo();
            byte[] readedData = null;
            readedData = store.getRecord(n);
            this.convertByteToTime(readedData, result);
            readedData = null;
            readedData = store.getRecord(n1);
            result.setInfo(this.convertByteToString(readedData));
            return result;
        }
        catch (RecordStoreException ex) {
            throw new RuntimeException("FileNotFound");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {}
        }
    }

    public City[] getCities() {
        RecordStore store = null;
        City[] result = new City[]{};
        try {
            store = RecordStore.openRecordStore((String)"ru.xe.kon.ay1.data", (boolean)true);
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
        try {
            int count = store.getNumRecords();
            if (count == 0) {
                City[] cityArray = result;
                return cityArray;
            }
            int[] sizes = ConvertUtils.getSizes(store.getRecord(1));
            if (sizes == null || sizes.length < 4) {
                City[] ex = result;
                return ex;
            }
            int length = sizes[0];
            result = this.convertByteToCities(store.getRecord(length));
        }
        catch (Exception ex) {
            throw new RuntimeException("Exception");
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreNotOpenException e) {
            }
            catch (RecordStoreException ex) {
                return new City[0];
            }
        }
        return result;
    }

    public void initData() {
        String[] ads;
        String[] systemData = this.getSysData();
        if (systemData[2] == null) {
            if ((systemData = this.konHttpFacade.registration(systemData))[2] == null) {
                return;
            }
            this.saveSysData(systemData, this.konHttpFacade.getCitiesAndSave(systemData));
            first = true;
            return;
        }
        boolean dataLoaded = false;
        dataLoaded = systemData[5] == null ? false : "true".equals(systemData[5].trim().toLowerCase());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int year = calendar.get(1);
        int month = calendar.get(2);
        if (dataLoaded) {
            if (systemData[4] == null || systemData[3] == null) {
                dataLoaded = false;
            } else {
                int sysMonth;
                int sysYear;
                String currYear = systemData[4];
                String currMonth = systemData[3];
                if (Util.isEmpty(currYear)) {
                    currYear = "-1";
                }
                if (Util.isEmpty(currMonth)) {
                    currMonth = "-1";
                }
                try {
                    sysYear = Integer.parseInt(currYear);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("currYear = " + currYear);
                }
                try {
                    sysMonth = Integer.parseInt(currMonth);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("currMonth = " + currMonth);
                }
                if (year != sysYear || month != sysMonth) {
                    dataLoaded = false;
                }
            }
        }
        if (dataLoaded && ((ads = this.getAdvertisings()) == null || ads.length == 0)) {
            dataLoaded = false;
        }
        if (!dataLoaded) {
            systemData[4] = String.valueOf(year);
            systemData[3] = String.valueOf(month);
            systemData[5] = String.valueOf(dataLoaded);
            this.saveSysData(systemData);
            try {
                dataLoaded = true;
                this.gettingDataFromServer(true);
            }
            catch (Exception ex) {
                systemData = this.getSysData();
                systemData[5] = String.valueOf(false);
                this.saveSysData(systemData);
                throw new RuntimeException(ex.getMessage());
            }
            systemData = this.getSysData();
            systemData[5] = String.valueOf(true);
            this.saveSysData(systemData);
        }
    }

    public void gettingDataFromServer(boolean monthBegin) {
        if (first) {
            return;
        }
        try {
            this.konHttpFacade.getDataAndSave(this.getSysData(), monthBegin);
        }
        catch (Exception ex) {
            boolean i = true;
            ex.printStackTrace();
        }
    }
}

