/*
 * Decompiled with CFR 0.152.
 */
package ru.xe.kon.core;

import java.util.Calendar;
import java.util.Date;

public class KonUtils {
    public static String getTwoDigitFormat(Integer t) {
        String result;
        int i;
        int n = i = t == null ? -1 : t;
        if (i >= 0) {
            result = String.valueOf(i);
            if (result.length() == 1) {
                result = "0" + result;
            }
        } else {
            result = "--";
        }
        return result;
    }

    public static String getTimeFormat(Integer h, Integer m) {
        return KonUtils.getTwoDigitFormat(h) + ":" + KonUtils.getTwoDigitFormat(m);
    }

    public static String getCurrentDate() {
        StringBuffer result = new StringBuffer();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        int d = c.get(5);
        if (d < 10) {
            result.append("0");
        }
        result.append(String.valueOf(d));
        result.append(".");
        d = c.get(2) + 1;
        if (d < 10) {
            result.append("0");
        }
        result.append(String.valueOf(d));
        result.append(".");
        result.append(String.valueOf(c.get(1)));
        return result.toString();
    }

    public static int getDaysInCurrentMonth() {
        int result = 31;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int month = calendar.get(2);
        return KonUtils.getDaysInMonth(month);
    }

    public static int getDaysInMonth(int month) {
        int result = 31;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        switch (month) {
            case 1: {
                result = 28;
                int year = calendar.get(1);
                if (year % 4 != 0 || year % 400 == 0) break;
                ++result;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                result = 30;
                break;
            }
            default: {
                result = 31;
            }
        }
        return result;
    }

    public static void addMinsToCalendar(Calendar c, int d) {
        int day = c.get(5);
        int month = c.get(2);
        int year = c.get(1);
        int h = c.get(11);
        int m = c.get(12);
        if ((m += d) < 0) {
            m += 60;
            if (--h < 0) {
                h += 24;
                if (--day < 1) {
                    if (--month < 0) {
                        month += 12;
                        --year;
                    }
                    day = KonUtils.getDaysInMonth(month);
                }
            }
        }
        c.set(1, year);
        c.set(2, month);
        c.set(5, day);
        c.set(11, h);
        c.set(12, m);
    }
}

